<?php

namespace App\Http\Controllers;

use App\Models\M_Kepemilikan;
use App\Models\M_Jadwal;
use App\Models\M_SensorUltrasonic;
use App\Models\M_SensorDHT22;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use Illuminate\Http\Request;

class AdminController extends Controller
{
    public function index()
    {
        $kandangs = M_Kepemilikan::all();
        $users = User::all(); // Mengambil semua pengguna
        return view('admin.dashboard', compact('kandangs', 'users'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'nama_kandang' => 'required|string|max:255',
            'id_user' => 'required|exists:users,id_user', // Validasi id_user
            'waktu_pagi' => 'required|date_format:H:i',
            'waktu_siang' => 'required|date_format:H:i',
            'waktu_sore' => 'required|date_format:H:i',
            'suhu' => 'required|numeric',
            'kelembaban' => 'required|numeric',
            'jarak_pakan' => 'required|numeric',
        ]);

        // Mendapatkan id_user dari request atau sesi
        $id_user = $request->id_user; // Anda juga bisa menggunakan Auth::id() jika sesuai dengan kebutuhan Anda

        // Simpan data kandang
        $kandang = M_Kepemilikan::create([
            'nama_kandang' => $request->nama_kandang,
            'id_user' => $id_user,
        ]);

        // Simpan jadwal
        M_Jadwal::create([
            'id_user' => $id_user,
            'id_kandang' => $kandang->id_kandang,
            'keterangan' => 'Makan Pagi',
            'waktu' => $request->waktu_pagi,
        ]);

        M_Jadwal::create([
            'id_user' => $id_user,
            'id_kandang' => $kandang->id_kandang,
            'keterangan' => 'Makan Siang',
            'waktu' => $request->waktu_siang,
        ]);

        M_Jadwal::create([
            'id_user' => $id_user,
            'id_kandang' => $kandang->id_kandang,
            'keterangan' => 'Makan Sore',
            'waktu' => $request->waktu_sore,
        ]);

        // Simpan data sensor
        M_SensorDHT22::create([
            'id_user' => $id_user, // Memastikan id_user disimpan
            'id_kandang' => $kandang->id_kandang,
            'suhu' => $request->suhu,
            'kelembaban' => $request->kelembaban,
        ]);

        // Simpan data jarak pakan
        M_SensorUltrasonic::create([
            'id_user' => $id_user, // Memastikan id_user disimpan
            'id_kandang' => $kandang->id_kandang,
            'data' => $request->jarak_pakan,
        ]);

        return redirect()->route('admin.dashboard')->with('success', 'Kandang dan jadwal berhasil ditambahkan!');
    }
    
    
    public function viewKandang($id_kandang)
    {
        $kandang = M_Kepemilikan::findOrFail($id_kandang);
        $sensor = M_SensorDHT22::where('id_kandang', $id_kandang)->first();
        $jadwalPagi = M_Jadwal::where('id_kandang', $id_kandang)->where('keterangan', 'Makan Pagi')->first();
        $jadwalSiang = M_Jadwal::where('id_kandang', $id_kandang)->where('keterangan', 'Makan Siang')->first();
        $jadwalSore = M_Jadwal::where('id_kandang', $id_kandang)->where('keterangan', 'Makan Sore')->first();
        $sensorUltrasonic = M_SensorUltrasonic::where('id_kandang', $id_kandang)->first();

        return view('admin.kandang-detail', compact('kandang', 'sensor', 'jadwalPagi', 'jadwalSiang', 'jadwalSore', 'sensorUltrasonic'));
    }

    public function getUserDetail($id_user)
{
    $user = User::findOrFail($id_user);

    return response()->json([
        'name' => $user->name,
        'username' => $user->username,
        'email' => $user->email,
    ]);
}


    public function destroy($id_kandang)
    {
        $kandang = M_Kepemilikan::findOrFail($id_kandang);
        $kandang->delete();

        return redirect()->route('admin.dashboard')->with('success', 'Kandang berhasil dihapus!');
    }
}
