<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class LoginController extends Controller
{
    public function showLoginForm()
    {
        return view('login.index');
    }

    public function login(Request $request)
    {
        // Validasi input
        $request->validate([
            'email' => 'required|email',
            'password' => 'required|string',
        ]);

        // $credentials = $request->only('email', 'password');

        if (Auth::attempt()) {
            // Jika autentikasi berhasil
            $request->session()->regenerate();
            return redirect()->route('dashboard');
        } else {
            // Jika autentikasi gagal
            return redirect()->back()->withErrors(['email' => 'Email atau password salah']);
        }
    }

    public function logout()
    {
        Auth::logout();
        return redirect()->route('login');
    }
}
