<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\M_SensorDHT22;
use App\Models\M_Jadwal;
use App\Models\M_Kepemilikan;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;


class SensorDHT22 extends Controller
{
    
    public function index()
    {
        $user = Auth::user();
        if (!$user) {
            return redirect()->route('login');
        }
        
        // Default dashboard view jika user belum memilih kandang
        return view('dashboard', ['user' => $user]);
    }

    public function dashboardKandang($id_user, $id_kandang)
    {
        
        $user = Auth::user();
        $kandang = M_Kepemilikan::where('id_user', $user->id_user)
                                ->where('id_kandang', $id_kandang)
                                ->first();

        if (!$kandang) {
            return redirect()->back()->withErrors(['error' => 'Kandang tidak ditemukan atau tidak dimiliki oleh user ini.']);
        }

        // Ambil data dari database
        $sensor = M_SensorDHT22::where('id_user', $user->id_user)
                               ->where('id_kandang', $id_kandang)
                               ->first();
        $jadwalPagi = M_Jadwal::where('id_user', $user->id_user)
                              ->where('keterangan', 'Makan Pagi')
                              ->first();
        $jadwalSiang = M_Jadwal::where('id_user', $user->id_user)
                               ->where('keterangan', 'Makan Siang')
                               ->first();
        $jadwalSore = M_Jadwal::where('id_user', $user->id_user)
                              ->where('keterangan', 'Makan Sore')
                              ->first();

        return view('dashboard', compact('sensor', 'jadwalPagi', 'jadwalSiang', 'jadwalSore', 'user', 'kandang','id_kandang'));
    }
    // DHT
    public function bacasuhu($id_user, $id_kandang)
    {
        $sensor = M_SensorDHT22::where('id_user', $id_user)
                               ->where('id_kandang', $id_kandang)
                               ->get();

        return view('bacasuhu', ['nilaisensor' => $sensor]);
    }

    public function bacakelembaban($id_user, $id_kandang)
    {
        $sensor = M_SensorDHT22::where('id_user', $id_user)
                               ->where('id_kandang', $id_kandang)
                               ->get();

        return view('bacakelembaban', ['nilaisensor' => $sensor]);
    }

    public function bacawaktu()
    {
        $user = Auth::user();

        // baca nilai pada tabel tb_sensor dan ambil nilai nya berdasarkan user id
        $sensor = M_SensorDHT22::where('id_user', $user->id_user)->get();

        // kirim ke tampilan baca waktu yang ada di view
        // return view('bacawaktu', ['nilaisensor' => $sensor]);
    }

    // public function simpansensor()
    // {
    //     $user = Auth::user();

    //     // ini berfungsi untuk menyimpan nilai sensor kedatabase berdasarkan user id
    //     M_SensorDHT22::where('id_user', $user->id_user)->where('id', '1')
    //         ->update(['suhu' => request()->nilaisuhu, 'kelembaban' => request()->nilaikelembaban]);
    // }
    public function simpansensor($id_user, $id_kandang, $nilaisuhu, $nilaikelembaban)
    {
        // Validasi input
        if (!is_numeric($nilaisuhu) || !is_numeric($nilaikelembaban)) {
            return response()->json(['error' => 'Nilai suhu dan kelembaban harus berupa angka.'], 400);
        }
    
        // Cari record sensor berdasarkan id_user dan id_kandang
        $sensor = M_SensorDHT22::where('id_user', $id_user)
                               ->where('id_kandang', $id_kandang)
                               ->first();
    
        if ($sensor) {
            // Jika sensor ditemukan, lakukan update
            $sensor->update([
                'suhu' => $nilaisuhu,
                'kelembaban' => $nilaikelembaban,
            ]);
        } else {
            // Jika sensor tidak ditemukan, tampilkan pesan error
            return response()->json(['error' => 'Sensor tidak ditemukan untuk user dan kandang ini.'], 404);
        }
    
        // Redirect atau response sesuai kebutuhan
        return response()->json(['success' => 'Nilai sensor berhasil disimpan'], 200);
    }
    

   public function simpanWaktu(Request $request, $id_user, $id_kandang)
{
    // Validasi input
    $request->validate([
        'waktu_pagi' => 'required|date_format:H:i',
        'waktu_siang' => 'required|date_format:H:i',
        'waktu_sore' => 'required|date_format:H:i',
    ]);

    // Jika validasi sukses, lakukan pembaruan
    M_Jadwal::where('id_user', $id_user)
            ->where('id_kandang', $id_kandang)
            ->where('keterangan', 'Makan Pagi')
            ->update(['waktu' => $request->waktu_pagi]);

    M_Jadwal::where('id_user', $id_user)
            ->where('id_kandang', $id_kandang)
            ->where('keterangan', 'Makan Siang')
            ->update(['waktu' => $request->waktu_siang]);

    M_Jadwal::where('id_user', $id_user)
            ->where('id_kandang', $id_kandang)
            ->where('keterangan', 'Makan Sore')
            ->update(['waktu' => $request->waktu_sore]);

    return redirect()->back()->with('success', 'Waktu pakan berhasil diatur');
}

}
