<?php

namespace App\Http\Controllers;

use App\Models\M_SensorUltrasonic;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;

class SensorUltrasonic extends Controller
{
    public function index()
    {
        $user = Auth::user();
        $sensor = DB::table('tb_jarak_pakan')
            ->where('id_user', $user->id_user)
            ->where('id_sensoor', 1)
            ->first();
        return view('dashboard', [
            'nilaisensor' => $sensor
        ]);
    }

    public function bacajarak($id_user, $id_kandang)
    {
        $user = Auth::user();
        $sensor = M_SensorUltrasonic::where('id_user', $id_user)
            ->where('id_kandang', $id_kandang)

            ->get();
        // kirim ke tampilan baca jarak yang ada di view
        return view('bacajarak', ['nilaisensor' => $sensor]);
    }

    // public function simpansensorjarak()
    // {
    //     $user = Auth::user();
    //     // ini berfungsi untuk menyimpan nilai sensor ke database berdasarkan user id
    //     M_SensorUltrasonic::where('id_user', $user->id_user)
    //                       ->where('id_sensor', '1')
    //                       ->update(['data' => request()->nilaidatasensor]);
    // }
    public function simpansensorjarak($id_user, $id_kandang, $nilaidatasensor)
    {
        // Validasi input
        if (!is_numeric($nilaidatasensor)) {
            return redirect()->back()->with('error', 'Nilai data sensor harus berupa angka.');
        }
    
        // Cari record sensor ultrasonik berdasarkan id_user dan id_kandang
        $sensor = M_SensorUltrasonic::where('id_user', $id_user)
                                     ->where('id_kandang', $id_kandang)
                                     ->first();
    
        if ($sensor) {
            // Jika sensor ditemukan, lakukan update
            $sensor->update([
                'data' => $nilaidatasensor,
            ]);
        } else {
            // Jika sensor tidak ditemukan, tampilkan pesan error
            return response()->json(['error' => 'Sensor tidak ditemukan untuk user dan kandang ini.'], 404);
        }
    
        // Redirect atau response sesuai kebutuhan
        return response()->json(['success' => 'Nilai sensor berhasil disimpan'], 200);
    }
    
}
