<?php

namespace App\Models;

use Illuminate\Contracts\Auth\Authenticatable as AuthenticatableContract;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable implements AuthenticatableContract
{
    use HasApiTokens, Notifiable;

    protected $table = 'users'; // Menggunakan nama tabel yang benar
    protected $primaryKey = 'id_user';
    protected $fillable = [
        'name', 'email', 'password','role_id',
    ];

    protected $hidden = [
        'password', 
        // 'remember_token',
    ];

    protected $casts = [
        'email_verified_at' => 'datetime',
    ];
    public function kandangs()
    {
        return $this->hasMany(M_Kepemilikan::class, 'id_user', 'id_user');
    }
       // Relasi ke model Role
       public function role()
       {
           return $this->belongsTo(Role::class, 'role_id');
       }
}
