<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Admin</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f8f9fa;
        }

        .container {
            background-color: #fff;
            border-radius: 10px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
            padding: 2rem;
            margin-top: 3rem;
        }

        .table th,
        .table td {
            vertical-align: middle;
        }

        .btn-icon {
            padding: 0.375rem 0.75rem;
            font-size: 0.875rem;
            line-height: 1.5;
            border-radius: 0.2rem;
            margin-right: 0.25rem;
            /* Menambahkan margin kanan */
        }

        .btn-info {
            background-color: #17a2b8;
            border-color: #17a2b8;
        }

        .btn-info:hover {
            background-color: #138496;
            border-color: #117a8b;
        }

        .btn-danger {
            background-color: #dc3545;
            border-color: #dc3545;
        }

        .btn-danger:hover {
            background-color: #c82333;
            border-color: #bd2130;
        }

        .modal-content {
            border-radius: 10px;
        }

        .modal-header {
            border-bottom: 1px solid #dee2e6;
        }
    </style>
</head>

<body>
    <div class="container">
        <h1>Dashboard Admin</h1>
        <div class="mb-3">
            <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#tambahDataModal">Tambah
                Kandang</button>
        </div>
        <table class="table table-bordered table-hover">
            <thead class="table-light">
                <tr>
                    <th>Nama Kandang</th>
                    <th>Pengguna</th>
                    <th>Aksi</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($kandangs as $kandang)
                    <tr>
                        <td>{{ $kandang->nama_kandang }}</td>
                        <td>{{ $kandang->user->name }}</td>
                        <td>
                            <a href="{{ route('admin.viewKandang', $kandang->id_kandang) }}"
                                class="btn btn-info btn-icon" title="Lihat">
                                <i class="fas fa-eye"></i>
                            </a>
                            <form action="{{ route('admin.destroy', $kandang->id_kandang) }}" method="POST"
                                style="display:inline-block;">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger btn-icon" title="Hapus">
                                    <i class="fas fa-trash-alt"></i>
                                </button>
                            </form>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>

    <!-- Modal Tambah Kandang -->
    <div class="modal fade" id="tambahDataModal" tabindex="-1" aria-labelledby="tambahDataModalLabel"
        aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="tambahDataModalLabel">Tambah Kandang</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form action="{{ route('admin.store') }}" method="POST">
                        @csrf
                        <div class="mb-3">
                            <label for="nama_kandang" class="form-label">Nama Kandang</label>
                            <input type="text" class="form-control" id="nama_kandang" name="nama_kandang" required>
                        </div>
                        <div class="mb-3">
                            <label for="id_user" class="form-label">Pilih Pengguna</label>
                            <select class="form-select" id="id_user" name="id_user" required>
                                @foreach ($users as $user)
                                    <option value="{{ $user->id_user }}">{{ $user->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="mb-3">
                            <label for="waktu_pagi" class="form-label">Jadwal Pagi</label>
                            <input type="time" class="form-control" id="waktu_pagi" name="waktu_pagi" required>
                        </div>
                        <div class="mb-3">
                            <label for="waktu_siang" class="form-label">Jadwal Siang</label>
                            <input type="time" class="form-control" id="waktu_siang" name="waktu_siang" required>
                        </div>
                        <div class="mb-3">
                            <label for="waktu_sore" class="form-label">Jadwal Sore</label>
                            <input type="time" class="form-control" id="waktu_sore" name="waktu_sore" required>
                        </div>
                        <div class="mb-3">
                            <label for="suhu" class="form-label">Suhu</label>
                            <input type="number" step="0.1" class="form-control" id="suhu" name="suhu" placeholder="Akan disesuaikan dengan data dari sensor" required>
                        </div>
                        <div class="mb-3">
                            <label for="kelembaban" class="form-label">Kelembaban</label>
                            <input type="number" step="0.1" class="form-control" id="kelembaban" name="kelembaban" placeholder="Akan disesuaikan dengan data dari sensor" required>
                        </div>
                        <div class="mb-3">
                            <label for="jarak_pakan" class="form-label">Ketersediaan Pakan</label>
                            <input type="number" class="form-control" id="jarak_pakan" name="jarak_pakan" placeholder="Akan disesuaikan dengan data dari sensor" required>
                        </div>
                        <button type="submit" class="btn btn-primary">Tambah</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/js/all.min.js"></script>
</body>

</html>
