<!-- resources/views/grafik.blade.php -->

<div class="card">
    <div class="card-header">Grafik Suhu</div>

    <div class="card-body">
        <canvas id="grafikSuhu" width="400" height="200"></canvas>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script>
        $(document).ready(function() {
            var ctx = document.getElementById('grafikSuhu').getContext('2d');
            var chart = new Chart(ctx, {
                type: 'line',
                data: {
                    labels: [],
                    datasets: [{
                        label: 'Suhu',
                        data: [],
                        backgroundColor: 'rgba(255, 99, 132, 0.2)',
                        borderColor: 'rgba(255, 99, 132, 1)',
                        borderWidth: 1
                    }]
                },
                options: {
                    scales: {
                        yAxes: [{
                            ticks: {
                                beginAtZero: true
                            }
                        }]
                    }
                }
            });

            // Fungsi untuk memperbarui grafik suhu
            function updateChart() {
                $.ajax({
                    url: "<?php echo e(route('grafik.data')); ?>",
                    method: "GET",
                    success: function(data) {
                        var labels = [];
                        var suhuData = [];

                        // Ambil data suhu dari respons dan masukkan ke dalam array
                        for (var i in data) {
                            labels.push(data[i].created_at);
                            suhuData.push(data[i].suhu);
                        }

                        // Perbarui data dalam grafik
                        chart.data.labels = labels;
                        chart.data.datasets[0].data = suhuData;
                        chart.update();
                    }
                });
            }

            // Panggil fungsi updateChart setiap detik
            setInterval(updateChart, 1000);
        });
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH C:\xampp\htdocs\LaraIoT_V1\resources\views/grafik.blade.php ENDPATH**/ ?>