<!-- resources/views/admin/kandang-detail.blade.php -->
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Detail Kandang</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .progress {
            width: 50%; /* Atur lebar progress bar menjadi lebih kecil */
            /* margin: auto; Posisikan progress bar di tengah */
        }
        .progress-bar {
            height: 30px; /* Atur tinggi progress bar */
        }
    </style>
</head>
<body>
    <div class="container mt-5">
        <h1>Detail Kandang</h1>
        <div class="card">
            <div class="card-header">
                Kandang: <?php echo e($kandang->nama_kandang); ?>

            </div>
            <div class="card-body">
                <h5 class="card-title">Pengguna: <?php echo e($kandang->user->name); ?></h5>
                <p class="card-text">Suhu: <?php echo e($sensor ? $sensor->suhu : '-'); ?></p>
                <p class="card-text">Kelembaban: <?php echo e($sensor ? $sensor->kelembaban : '-'); ?></p>
                <h5>Jadwal Pemberian Pakan:</h5>
                <p class="card-text">Pagi: <?php echo e($jadwalPagi ? $jadwalPagi->waktu : '-'); ?></p>
                <p class="card-text">Siang: <?php echo e($jadwalSiang ? $jadwalSiang->waktu : '-'); ?></p>
                <p class="card-text">Sore: <?php echo e($jadwalSore ? $jadwalSore->waktu : '-'); ?></p>
                <h5>Ketersediaan Pakan:</h5>
                <div class="progress">
                    <div id="feed-level" class="progress-bar" role="progressbar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100" style="width: 0%;"></div>
                </div>
                <p class="card-text mt-2">Ketersediaan Pakan: <span id="jumlah_pakan">0</span>%</p>
                <a href="<?php echo e(route('admin.dashboard')); ?>" class="btn btn-primary">Kembali ke Dashboard</a>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        function updateProgressBar(value) {
            var maxHeight = 14; // ketinggian maksimal pakan
            var minHeight = 3; // ketinggian minimal pakan yang dianggap penuh
            var percentage = ((maxHeight - value) / (maxHeight - minHeight)) * 100;
            percentage = Math.max(0, Math.min(100, percentage)); // memastikan persentase antara 0 dan 100

            var feedLevel = document.getElementById("feed-level");
            feedLevel.style.width = percentage + "%";
            feedLevel.setAttribute("aria-valuenow", percentage);

            var jumlahPakan = document.getElementById("jumlah_pakan");
            jumlahPakan.textContent = percentage.toFixed(); // menampilkan persentase dengan dua angka desimal

            // Optional: change color based on level
            if (percentage > 75) {
                feedLevel.style.backgroundColor = "#28a745"; // Hijau
            } else if (percentage > 50) {
                feedLevel.style.backgroundColor = "#ffc107"; // Kuning
            } else if (percentage > 25) {
                feedLevel.style.backgroundColor = "#fd7e14"; // Oren
            } else {
                feedLevel.style.backgroundColor = "#dc3545"; // Merah
            }
        }

        // Update progress bar dengan nilai dari sensor
        var sensorValue = <?php echo e($sensorUltrasonic ? $sensorUltrasonic->data : 'null'); ?>;
        if (sensorValue !== null) {
            updateProgressBar(sensorValue);
        }
    </script>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\LaraIoT_V3\resources\views/admin/kandang-detail.blade.php ENDPATH**/ ?>