<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\User;

class AuthController extends Controller
{
    public function showLoginForm()
    {
        return view('Login.index');
    }

    public function login(Request $request)
    {
        // Validasi input
        $credentials = $request->only('email', 'password');

        if (Auth::attempt($credentials)) {
            // Jika login berhasil
            $user = Auth::user();
            if ($user->role_id == 1) {
                // Jika admin
                return redirect()->route('admin.dashboard');
            } else {
                // Jika bukan admin
                return redirect()->route('pilihkandang', ['id_user' => $user->id_user]);
            }
        }

        // Jika login gagal
        return redirect()->back()->withErrors(['email' => 'Email atau password salah.']);
    }

    public function logout(Request $request)
    {
        Auth::logout();
        return redirect('login');
    }
}
