<?php

namespace App\Http\Controllers;

use App\Models\M_Perintah;
use App\Models\M_Jadwal;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class Perintah extends Controller
{
    public function index()
    {
        $user = Auth::user(); // Mendapatkan user yang sedang login

        // Mengambil semua data perintah untuk user yang sesuai
        $perintah = M_Perintah::where('id_user', $user->id)->get();

        // Mengambil semua data jadwal untuk user yang sesuai
        $jadwal = M_Jadwal::where('id_user', $user->id)->get();

        return view('dashboard', ['nilaisensor' => $perintah, 'jadwal' => $jadwal]);
    }

    public function bacaperintah($id_user, $id_kandang)
    {
        date_default_timezone_set('Asia/Singapore');
        $waktu_sekarang = date("H:i");

        // Mengambil data jadwal yang sesuai dengan waktu sekarang, id_user, dan id_kandang yang sesuai
        $jadwal = M_Jadwal::where('id_user', $id_user)
                         ->where('id_kandang', $id_kandang)
                         ->where('waktu', $waktu_sekarang)
                         ->get();

        // Jika ada jadwal pada waktu sekarang, kirim "ON", jika tidak kirim "OFF"
        if ($jadwal->count() > 0) {
            return response("ON");
        } else {
            return response("OFF");
        }
    }
}
