<?php

namespace App\Http\Controllers;

use App\Models\M_Kepemilikan;
use App\Models\M_SensorDHT22;
use App\Models\M_SensorUltrasonic;
use App\Models\M_Jadwal;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class PilihKandangController extends Controller
{
    public function pilihKandang($id_user)
    {
        $kandangs = M_Kepemilikan::where('id_user', $id_user)->get();
        return view('pilihkandang', compact('kandangs', 'id_user'));
    }
    
    public function storeKandang(Request $request){
       
        $request->validate([
            'nama_kandang' => 'required|string|max:255',
            'waktu_pagi' => 'required|date_format:H:i',
            'waktu_siang' => 'required|date_format:H:i',
            'waktu_sore' => 'required|date_format:H:i',
            'suhu' => 'required|numeric',
            'kelembaban' => 'required|numeric',
            'jarak_pakan' => 'required|numeric',
        ]);

        // Dapatkan id user yang sedang login
        $id_user = Auth::id();

        // Buat kandang baru
        $kandang = M_Kepemilikan::create([
            'nama_kandang' => $request->nama_kandang,
            'id_user' => $id_user,
        ]);

        // Tambah jadwal pakan
        M_Jadwal::create([
            'id_user' => $id_user,
            'id_kandang' => $kandang->id_kandang,
            'keterangan' => 'Makan Pagi',
            'waktu' => $request->waktu_pagi,
        ]);
        M_Jadwal::create([
            'id_user' => $id_user,
            'id_kandang' => $kandang->id_kandang,
            'keterangan' => 'Makan Siang',
            'waktu' => $request->waktu_siang,
        ]);
        M_Jadwal::create([
            'id_user' => $id_user,
            'id_kandang' => $kandang->id_kandang,
            'keterangan' => 'Makan Sore',
            'waktu' => $request->waktu_sore,
        ]);

        // Tambah data sensor
        M_SensorDHT22::create([
            'id_user' => $id_user,
            'id_kandang' => $kandang->id_kandang,
            'suhu' => $request->suhu,
            'kelembaban' => $request->kelembaban,
        ]);

        // Tambah data jarak pakan
        M_SensorUltrasonic::create([
            'id_user' => $id_user,
            'id_kandang' => $kandang->id_kandang,
            'data' => $request->jarak_pakan,
        ]);

        // Redirect dengan pesan sukses
        return redirect()->back()->with('success', 'Data berhasil ditambahkan!');
    }
    

    public function getSensorData($id_kandang)
    {
        $sensor = M_SensorDHT22::where('id_kandang', $id_kandang)->first();

        if ($sensor) {
            return response()->json([
                'suhu' => $sensor->suhu,
                'kelembaban' => $sensor->kelembaban,
            ]);
        } else {
            return response()->json([
                'suhu' => '-',
                'kelembaban' => '-',
            ]);
        }
    }

    public function bacajarak($id_user, $id_kandang)
    {
        $sensor = M_SensorUltrasonic::where('id_user', $id_user)
                                     ->where('id_kandang', $id_kandang)
                                     ->first();

        if ($sensor) {
            return response()->json($sensor->data);
        } else {
            return response()->json(['error' => 'Data not found'], 404);
        }
    }
    public function dashboardKandang($id_kandang)
    {
        $sensor = M_SensorDHT22::where('id_kandang', $id_kandang)->first();
        return view('dashboardKandang', compact('sensor'));
    }
}
