<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pilih Kandang</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        body {
            background: linear-gradient(135deg, #f8f9fa, #e9ecef);
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            font-family: 'Arial', sans-serif;
            margin: 0;
        }

        .container {
            max-width: 900px;
            padding: 20px;
            text-align: center;
        }

        .card {
            margin: 10px;
            border: none;
            box-shadow: 0 6px 18px rgba(0, 0, 0, 0.1);
            transition: transform 0.3s ease, box-shadow 0.3s ease;
            border-radius: 12px;
            flex: 1 0 21%;
            display: flex;
            flex-direction: column;
            text-align: center;
        }

        .card:hover {
            transform: translateY(-10px);
            box-shadow: 0 12px 24px rgba(0, 0, 0, 0.2);
        }

        .card-icon {
            font-size: 2.5rem;
            color: #17a2b8;
            margin-bottom: 10px;
        }

        .container h1 {
            margin-bottom: 20px;
            font-weight: bold;
            color: #343a40;
        }

        .card-body {
            display: flex;
            flex-direction: column;
            align-items: center;
            padding: 20px;
        }

        .info {
            width: 100%;
            margin-top: 10px;
            padding: 10px;
            border-radius: 8px;
            background-color: #e9ecef;
        }

        .info-text {
            display: flex;
            align-items: center;
            justify-content: flex-start;
            margin-bottom: 5px;
            color: #343a40;
        }

        .info-text i {
            margin-right: 5px;
            color: #17a2b8;
        }

        .btn-add-kandang {
            margin-top: 20px;
            width: 100%;
            background-color: #17a2b8;
            border: none;
            color: white;
            transition: background-color 0.3s ease;
        }

        .btn-add-kandang:hover {
            background-color: #138496;
        }

        @media (max-width: 576px) {
            .card {
                margin: 10px 0;
                flex: 1 0 100%;
            }
        }

        .btn-masuk {
            background: linear-gradient(135deg, #007bff, #0056b3);
            color: #fff;
            border: none;
            padding: 10px 20px;
            border-radius: 50px;
            font-size: 1rem;
            transition: background 0.3s ease, transform 0.3s ease;
        }

        .btn-masuk:hover {
            background: linear-gradient(135deg, #0056b3, #003d80);
            transform: translateY(-3px);
        }
    </style>
</head>

<body>
    <div class="container text-center">
        {{-- <h1>Pilih Kandang</h1> --}}
        @if ($kandangs->isEmpty())
        <div class="alert alert-warning" role="alert">
            Anda belum memiliki kandang. Silakan tambahkan kandang baru.
        </div>
        <button type="button" class="btn btn-primary btn-add-kandang" data-bs-toggle="modal" data-bs-target="#tambahKandangModal">
            Tambah Kandang
        </button>
        @endif
        <div class="row justify-content-center">
            @foreach ($kandangs as $kandang)
            <div class="col-md-6 col-lg-4 mb-4">
                <div class="card">
                    <div class="card-body">
                        <div class="card-icon">
                            <i class="fas fa-home"></i>
                        </div>
                        <h2 class="card-title">{{ $kandang->nama_kandang }}</h2>
                        <div class="info">
                            <div class="info-text"><i class="fas fa-thermometer-half"></i> Suhu: <span id="suhu-{{ $kandang->id_kandang }}">-</span> °C</div>
                            <div class="info-text"><i class="fas fa-tint"></i> Kelembaban: <span id="kelembaban-{{ $kandang->id_kandang }}">-</span> %</div>
                            <div class="info-text"><i class="fas fa-seedling"></i> Pakan: <span id="jarak-{{ $kandang->id_kandang }}">-</span></div>
                        </div>
                        <form action="{{ url('dashboard/kandang/' . $id_user . '/' . $kandang->id_kandang) }}" method="get">
                            <button type="submit" class="btn btn-masuk mt-3">Masuk</button>
                        </form>
                    </div>
                </div>
            </div>
            @endforeach
        </div>
    </div>

    <!-- Modal Tambah Kandang -->
    <div class="modal fade" id="tambahKandangModal" tabindex="-1" aria-labelledby="tambahKandangModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="tambahKandangModalLabel">Tambah Kandang Baru</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form action="{{ route('store.kandang') }}" method="POST">
                    @csrf
                    <div class="modal-body">
                        <div class="mb-3">
                            <label for="nama_kandang" class="form-label">Nama Kandang</label>
                            <input type="text" class="form-control" id="nama_kandang" name="nama_kandang" required>
                        </div>
                        <div class="mb-3">
                            <label for="waktu_pagi" class="form-label">Jadwal Pagi</label>
                            <input type="time" class="form-control" id="waktu_pagi" name="waktu_pagi" required>
                        </div>
                        <div class="mb-3">
                            <label for="waktu_siang" class="form-label">Jadwal Siang</label>
                            <input type="time" class="form-control" id="waktu_siang" name="waktu_siang" required>
                        </div>
                        <div class="mb-3">
                            <label for="waktu_sore" class="form-label">Jadwal Sore</label>
                            <input type="time" class="form-control" id="waktu_sore" name="waktu_sore" required>
                        </div>
                        <div class="mb-3">
                            <label for="suhu" class="form-label">Suhu</label>
                            <input type="number" step="0.1" class="form-control" id="suhu" name="suhu" placeholder="Akan di sesuaikan dengan data dari sensor"required>
                        </div>
                        <div class="mb-3">
                            <label for="kelembaban" class="form-label">Kelembaban</label>
                            <input type="number" step="0.1" class="form-control" id="kelembaban" name="kelembaban" placeholder="Akan di sesuaikan dengan data dari sensor" required>
                        </div>
                        <div class="mb-3">
                            <label for="jarak_pakan" class="form-label">Ketersediaan Pakan</label>
                            <input type="number"  class="form-control" id="jarak_pakan" name="jarak_pakan" placeholder="Akan di sesuaikan dengan data dari sensor" required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                        <button type="submit" class="btn btn-masuk">Simpan</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {
            setInterval(function() {
                @foreach ($kandangs as $kandang)
                    // Mendapatkan data suhu dan kelembaban
                    $.get("{{ url('getSensorData/' . $kandang->id_kandang) }}", function(data) {
                        console.log('Sensor data for kandang {{ $kandang->id_kandang }}:', data);
                        $("#suhu-{{ $kandang->id_kandang }}").text(data.suhu);
                        $("#kelembaban-{{ $kandang->id_kandang }}").text(data.kelembaban);
                    });

                    // Mendapatkan data jarak pakan
                    $.get("{{ url('bacajarak/' . $kandang->id_user . '/' . $kandang->id_kandang) }}",
                        function(jarak) {
                            console.log('Jarak data for kandang {{ $kandang->id_kandang }}:', jarak);

                            var maxHeight = 14; // ketinggian maksimal pakan
                            var minHeight = 3; // ketinggian minimal pakan yang dianggap penuh
                            var percentage = ((maxHeight - jarak) / (maxHeight - minHeight)) * 100;
                            percentage = Math.max(0, Math.min(100,
                            percentage)); // memastikan persentase antara 0 dan 100

                            $("#jarak-{{ $kandang->id_kandang }}").text(percentage.toFixed() + "%");

                            var feedLevel = document.getElementById(
                                "feed-level-{{ $kandang->id_kandang }}");
                            feedLevel.style.height = percentage + "%";
                            feedLevel.setAttribute("aria-valuenow", percentage);

                            // Optional: change color based on level
                            if (percentage > 75) {
                                feedLevel.style.backgroundColor = "#28a745"; // Hijau
                            } else if (percentage > 50) {
                                feedLevel.style.backgroundColor = "#ffc107"; // Kuning
                            } else if (percentage > 25) {
                                feedLevel.style.backgroundColor = "#fd7e14"; // Oren
                            } else {
                                feedLevel.style.backgroundColor = "#dc3545"; // merah
                            }
                        });
                @endforeach
            }, 1000);
        });
    </script>
</body>

</html>
