<?php

use App\Http\Controllers\SensorDHT22;
use App\Http\Controllers\Perintah;
use App\Http\Controllers\LoginController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\SensorUltrasonic;
use App\Http\Controllers\RegisterController;
use App\Http\Controllers\KepemilikanController;
use App\Http\Controllers\PilihkandangController;
use App\Http\Controllers\AdminController;
use App\Http\Middleware\Authenticate;
use Illuminate\Support\Facades\Auth;

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Route dashboard
Route::get('/', [SensorDHT22::class, 'index'])->name('dashboard');


// Route untuk login
Route::middleware(['auth'])->group(function () {
    Route::get('/dashboard', [AuthController::class, 'dashboard'])->name('dashboard');
    Route::get('/dashboard', [SensorDHT22::class, 'index'])->name('dashboard');
    // Route::get('pilihkandang', [PilihkandangController::class, 'pilihKandang'])->name('pilihkandang');
    Route::get('pilihkandang/{id_user}', [PilihKandangController::class, 'pilihKandang'])->name('pilihkandang');
    Route::get('/dashboard/kandang/{id_user}/{id_kandang}', [SensorDHT22::class, 'dashboardKandang'])->name('dashboard.kandang');

});
Route::get('login', [AuthController::class, 'showLoginForm'])->name('login');
Route::post('login', [AuthController::class, 'login']);
Route::post('logout', [AuthController::class, 'logout'])->name('logout');
// tambah pada view pilihkandang

Route::post('storekandang', [PilihKandangController::class, 'storeKandang'])->name('store.kandang');


// Route Daftar /Register
Route::get('register', [RegisterController::class, 'showRegisterForm'])->name('register');
Route::post('/register', [RegisterController::class, 'register']);
//Route Admin 
Route::middleware(['auth', 'is_admin'])->group(function () {
    Route::get('/admin', [AdminController::class, 'index'])->name('admin.dashboard');
    Route::post('/admin/store', [AdminController::class, 'store'])->name('admin.store');
    Route::delete('/admin/destroy/{id_kandang}', [AdminController::class, 'destroy'])->name('admin.destroy');
    Route::get('/admin/kandang/{id_kandang}', [AdminController::class, 'viewKandang'])->name('admin.viewKandang');
});
Route::get('/admin/user/{id_user}/detail', [AdminController::class, 'getUserDetailForModal'])->name('admin.getUserDetailForModal');



// pilih kandang
// Route::get('pilihkandang/{id}', [AuthController::class, 'pilihKandang'])->name('pilihkandang');
// Route::get('pilihkandang', [AuthController::class, 'pilihKandang'])->name('pilihkandang');
// Route::get('dashboard/kandang/{serial_number}', [AuthController::class, 'dashboardKandang'])->name('dashboard.kandang');

// Route::get('/pilihkandang', [PilihKandangController::class, 'index'])->name('pilihkandang');
Route::get('getSensorData/{id_kandang}', [PilihKandangController::class, 'getSensorData'])->name('getSensorData');

// Route::get('pilihkandang/{id_user}', [PilihkandangController::class, 'pilihKandang'])->name('pilihkandang');

// route dashboart tidak digunakan
// Route::get('dashboard/{id_kandang}', [PilihkandangController::class, 'dashboardKandang'])->name('dashboard.kandang');


// Route::get('pilihkandang', [PilihkandangController::class, 'pilihKandang'])->name('pilihkandang');
// Route::get('dashboard/{serial_number}', [PilihkandangController::class, 'dashboardKandang'])->name('dashboard.kandang');
// Route::get('/login', [LoginController::class, 'showLoginForm'])->name('login');
// Route::post('/login', [LoginController::class, 'login']);
// Route::post('/logout', [LoginController::class, 'logout'])->name('logout');



// sensor ultra sonic 
Route::get('/bacajarak/{id_user}/{id_kandang}', [SensorUltrasonic::class, 'bacajarak'])->name('bacajarak');
// Route::get('/simpansensorjarak/{nilaidatasensor}', [SensorUltrasonic::class, 'simpansensorjarak'])->name('simpansensorjarak');
Route::get('/simpansensorjarak/{id_user}/{id_kandang}/{nilaidatasensor}', [SensorUltrasonic::class, 'simpansensorjarak'])->name('simpansensorjarak');



// Sensor DHT 22
Route::get('/bacasuhu/{id_user}/{id_kandang}', [SensorDHT22::class, 'bacasuhu'])->name('bacasuhu');
Route::get('/bacakelembaban/{id_user}/{id_kandang}', [SensorDHT22::class, 'bacakelembaban'])->name('bacakelembaban');
Route::get('/simpan/{id_user}/{id_kandang}/{nilaisuhu}/{nilaikelembaban}', [SensorDHT22::class, 'simpansensor'])->name('simpansensor');

// Route untuk menyimpan nilai sensor ke tb_sensor
// Route::get('/simpan/{nilaisuhu}/{nilaikelembaban}', [SensorDHT22::class, 'simpansensor'])->name('simpansensor');
// Route::get('/bacaperintah', [Perintah::class, 'bacaperintah'])->name('bacaperintah');
Route::get('/bacaperintah/{id_user}/{id_kandang}', [Perintah::class, 'bacaperintah'])->name('bacaperintah');




 
// Route untuk menyimpan waktu
Route::post('/simpanwaktu/{id_user}/{id_kandang}', [SensorDHT22::class, 'simpanWaktu'])->name('simpanwaktu');


Route::post('/simpanwaktupagi', [SensorDHT22::class, 'simpanwaktupagi'])->name('simpanwaktupagi');
Route::post('/simpanwaktusiang', [SensorDHT22::class, 'simpanwaktusiang'])->name('simpanwaktusiang');
Route::post('/simpanwaktusore', [SensorDHT22::class, 'simpanwaktusore'])->name('simpanwaktusore');

// tambah untuk alat  pada dashboard user
Route::post('/kepemilikan/store', [KepemilikanController::class, 'store'])->name('kepemilikan.store');

// Route untuk membaca waktu pemberian pakan
Route::get('/ambil-waktu', [SensorDHT22::class, 'ambilWaktu'])->name('ambilwaktu');

// Route untuk mengatur waktu pemberian pakan
Route::post('/atur-waktu', [SensorDHT22::class, 'aturWaktu'])->name('aturwaktu');


// jika user tidak memiliki kandang/serial monitor maka buat baru 
Route::post('storekandang', [PilihkandangController::class, 'storeKandang'])->name('store.kandang');