<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard</title>
    <!-- Jquery -->
    <script type="text/javascript" src="<?php echo e(asset('jquery/jquery.min.js')); ?>"></script>
    <script type="text/javascript">
        $(document).ready(function() {
            setInterval(function() {
                $("#suhu").load("<?php echo e(url('bacasuhu/' . $user->id_user . '/' . $id_kandang)); ?>");
                $("#kelembaban").load("<?php echo e(url('bacakelembaban/' . $user->id_user . '/' . $id_kandang)); ?>");
                $("#jumlah_pakan").load("<?php echo e(url('bacajarak/' . $user->id_user . '/' . $id_kandang)); ?>",
                    function(response, status, xhr) {
                        if (status == "success") {
                            updateProgressBar(response);
                        }
                    });
            }, 1000);
        });
        // untuk jam 
        function updateClock() {
            var now = new Date();
            var hours = now.getHours();
            var minutes = now.getMinutes();
            var seconds = now.getSeconds();
            minutes = minutes < 10 ? '0' + minutes : minutes;
            seconds = seconds < 10 ? '0' + seconds : seconds;
            var timeString = hours + ':' + minutes + ':' + seconds;
            document.getElementById('clock').innerHTML = timeString;
        }

        setInterval(updateClock, 1000);
        updateClock(); // initial call to display clock immediately


        function updateProgressBar(value) {
            var maxHeight = 14; // ketinggian maksimal pakan
            var minHeight = 3; // ketinggian minimal pakan yang dianggap penuh
            var percentage = ((maxHeight - value) / (maxHeight - minHeight)) * 100;
            percentage = Math.max(0, Math.min(100, percentage)); // memastikan persentase antara 0 dan 100

            var feedLevel = document.getElementById("feed-level");
            feedLevel.style.height = percentage + "%";
            feedLevel.setAttribute("aria-valuenow", percentage);

            var jumlahPakan = document.getElementById("jumlah_pakan");
            jumlahPakan.textContent = percentage.toFixed(); // menampilkan persentase dengan dua angka desimal

            // Optional: change color based on level
            if (percentage > 75) {
                feedLevel.style.backgroundColor = "#28a745"; // Hijau
            } else if (percentage > 50) {
                feedLevel.style.backgroundColor = "#ffc107"; // Kuning
            } else if (percentage > 25) {
                feedLevel.style.backgroundColor = "#fd7e14"; // Oren
            } else {
                feedLevel.style.backgroundColor = "#dc3545"; // Merah
            }
        }

        // Contoh pemanggilan fungsi updateProgressBar dengan nilai tertentu
        updateProgressBar(3); // Misalnya, mengatur jarak pakan ke 3 cm yang akan menampilkan 100%
    </script>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome CSS -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <style>
         :root {
            --primary-color: #17a2b8;
            --background-color: #f8f9fa;
            --text-color: #343a40;
            --secondary-text-color: #6c757d;
        }

        body {
            background: linear-gradient(135deg, var(--background-color), #e9ecef);
            font-family: 'Arial', sans-serif;
        }

        .container {
            margin-top: 40px;
        }

        .card {
            margin-top: 20px;
            border: none;
            box-shadow: 0 6px 18px rgba(0, 0, 0, 0.1);
            transition: transform 0.3s ease;
            border-radius: 12px;
        }

        .card:hover {
            transform: translateY(-10px);
        }

        .card-title {
            font-size: 1.75rem;
            color: var(--text-color);
        }

        .card-text {
            font-size: 1.25rem;
            color: var(--secondary-text-color);
        }

        .icon {
            margin-right: 10px;
            color: var(--primary-color);
        }

        .input-group-text {
            width: 65px;
            background-color: var(--primary-color);
            color: white;
        }

        .input-group input {
            border-left: none;
        }

        .btn-primary {
            background-color: var(--primary-color);
            border: none;
            transition: background-color 0.3s ease;
        }

        .btn-primary:hover {
            background-color: darken(var(--primary-color), 10%);
        }

        .clock {
            text-align: center;
            font-size: 2.5rem;
            margin-top: 20px;
            color: var(--text-color);
            font-weight: bold;
        }

        .clock div {
            display: inline-block;
            padding: 10px 20px;
            background: var(--primary-color);
            color: white;
            border-radius: 8px;
            box-shadow: 0 6px 18px rgba(0, 0, 0, 0.1);
        }

        .clock div:before {
            content: '⌚ ';
        }

        .btn-info.btn-sm {
            border-radius: 50%;
            width: 30px;
            height: 30px;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 0;
        }

        .btn-info.btn-sm i {
            font-size: 1rem;
            color: white;
        }

        .progress {
            background-color: #e9ecef;
            border-radius: 10px;
            overflow: hidden;
            margin-top: 10px;
        }

        .progress-bar {
            background-color: var(--primary-color);
            height: 30px;
            transition: width 0.4s ease;
        }

        .feed-container {
            width: 100%;
            height: 170px;
            border: 2px solid var(--secondary-text-color);
            border-radius: 10px;
            background-color: #e9ecef;
            position: relative;
            overflow: hidden;
            box-shadow: inset 0 0 10px rgba(0, 0, 0, 0.1);
        }

        .feed-level {
            width: 100%;
            height: 0;
            background-color: var(--primary-color);
            position: absolute;
            bottom: 0;
            transition: height 0.4s ease;
        }

        .feed-level::before {
            content: '';
            position: absolute;
            top: -20px;
            left: 50%;
            transform: translateX(-50%);
            width: 60%;
            height: 20px;
            border-radius: 10px 10px 0 0;
        }

        .logout-btn {
            position: absolute;
            top: 20px;
            right: 20px;
        }

        .dropdown-content {
            display: none;
            position: absolute;
            background-color: #f9f9f9;
            min-width: 160px;
            box-shadow: 0px 8px 16px 0px rgba(0, 0, 0, 0.2);
            z-index: 1;
            border-radius: 5px;
            overflow: hidden;
        }

        .dropdown-content form,
        .dropdown-content button {
            display: block;
            color: black;
            padding: 12px 16px;
            text-decoration: none;
            background: none;
            border: none;
            width: 100%;
            text-align: left;
            cursor: pointer;
            transition: background-color 0.3s ease;
        }

        .dropdown-content button:hover {
            background-color: #f1f1f1;
        }

        .dropdown:hover .dropdown-content {
            display: block;
        }

        .dropdown-content::before {
            content: "";
            position: absolute;
            top: -10px;
            left: 50%;
            transform: translateX(-50%);
            border-width: 10px;
            border-style: solid;
            border-color: transparent transparent #f9f9f9 transparent;
        }

        .welcome-container {
            text-align: start;
            margin-bottom: 20px;
        }

        .profile-link {
            font-size: 1.5rem;
            color: var(--text-color);
            font-weight: bold;
            margin: 0;
            cursor: pointer;
        }

        .profile-link:hover {
            text-decoration: underline;
        }

        .dropdown:hover .dropdown-content {
            display: block;
        }

        .dropdown-content::before {
            content: "";
            position: absolute;
            top: -10px;
            left: 50%;
            transform: translateX(-50%);
            border-width: 10px;
            border-style: solid;
            border-color: transparent transparent #f9f9f9 transparent;
        }

        .welcome-container {
            text-align: start;
            margin-bottom: 20px;
        }

        .profile-link {
            font-size: 1.5rem;
            color: #343a40;
            font-weight: bold;
            margin: 0;
            cursor: pointer;
        }

        .profile-link:hover {
            text-decoration: underline;
        }
    </style>
</head>

<body>
    <div class="logout-btn">
        <div class="dropdown">
            <button class="btn btn-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
              Menu
            </button>
            <ul class="dropdown-menu">
              <li>
                <form action="#" method="POST" onsubmit="showTambahModal(); return false;">
                  <button type="submit" class="dropdown-item">
                    <i class="fas fa-plus icon"></i>Tambah
                  </button>
                </form>
              </li>
              <li>
                <form action="<?php echo e(route('pilihkandang', ['id_user' => Auth::id()])); ?>">
                  <?php echo csrf_field(); ?>
                  <input type="hidden" name="id_kandang" value="<?php echo e($id_kandang); ?>">
                  <button type="submit" class="dropdown-item">
                    <i class="fas fa-arrow-left icon"></i>Kembali
                  </button>
                </form>
              </li>
              <li>
                <form action="<?php echo e(route('logout')); ?>" method="POST">
                  <?php echo csrf_field(); ?>
                  <button type="submit" class="dropdown-item">
                    <i class="fas fa-sign-out-alt icon"></i>Logout
                  </button>
                </form>
              </li>
            </ul>
          </div>
    </div>
    

    <div class="container">
        <div class="welcome-container">
            <?php echo $__env->make('profil', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>

        <div class="clock">
            <div id="clock">
                <?php
                date_default_timezone_set('Asia/Singapore');
                echo date('H:i:s');
                ?>
            </div>
        </div>

        <div class="row">
            <div class="col-md-4">
                <div class="card">
                    <div class="card-body">
                        <h2 class="card-title">Suhu dan Kelembaban</h2>
                        <p class="card-text"><i class="fas fa-thermometer-half icon"></i>Suhu: <span
                                id="suhu">-</span> °C</p>
                        <p class="card-text"><i class="fas fa-tint icon"></i>Kelembaban: <span id="kelembaban">-</span>%
                        </p>
                    </div>
                </div>
            </div>

            <?php echo $__env->make('penjadwalanpakan', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <?php echo $__env->make('ketinggianpakan', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>

    <!-- Tambah Data Modal -->
    <?php echo $__env->make('crud.tambah', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Bootstrap JavaScript -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
    <!-- Font Awesome JavaScript -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/js/all.min.js"></script>

    <script>
        function showTambahModal() {
            var tambahDataModal = new bootstrap.Modal(document.getElementById('tambahDataModal'));
            tambahDataModal.show();
        }

        document.addEventListener('DOMContentLoaded', function() {
            var profileModal = new bootstrap.Modal(document.getElementById('profileModal'));
            var profileLink = document.getElementById('profileLink');

            profileLink.onclick = function() {
                profileModal.show();
            }
        });

        $(document).ready(function() {
            $('#detailModal').modal('show');
        });
    </script>
</body>

</html>
<?php /**PATH C:\xampp\htdocs\LaraIoT_V3\resources\views/dashboard.blade.php ENDPATH**/ ?>