<div class="col-md-4">
    <div class="card position-relative">
        <div class="card-body">
            <button type="button" class="btn btn-info btn-sm position-absolute top-0 end-0 m-2" data-bs-toggle="modal" data-bs-target="#detailModal">
                <i class="fas fa-info-circle"></i>
            </button>
            <h2 class="card-title">Penjadwalan Pakan</h2>
            <!-- Form gabungan untuk semua waktu -->
            <form id="penjadwalanForm" action="<?php echo e(route('simpanwaktu', ['id_user' => $user->id_user, 'id_kandang' => $id_kandang])); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="input-group mb-3">
                    <span class="input-group-text">Pagi</span>
                    <input type="time" id="waktu_pagi" name="waktu_pagi" class="form-control" min="05:00" max="10:00" value="<?php echo e($jadwalPagi->waktu); ?>">
                </div>
                <div class="input-group mb-3">
                    <span class="input-group-text">Siang</span>
                    <input type="time" id="waktu_siang" name="waktu_siang" class="form-control" min="10:01" max="15:00" value="<?php echo e($jadwalSiang->waktu); ?>">
                </div>
                <div class="input-group mb-3">
                    <span class="input-group-text">Sore</span>
                    
                    <input type="time" id="waktu_sore" name="waktu_sore" class="form-control"  value="<?php echo e($jadwalSore->waktu); ?>">
                </div>
                <div id="alertMessage" class="alert alert-danger d-none" role="alert">
                    Waktu terlalu berdekatan, mohon atur ulang.
                </div>
                <button type="submit" class="btn btn-primary w-100">Atur Semua</button>
            </form>
        </div>
    </div>
</div>

<!-- Modal -->
<div class="modal fade" id="detailModal" tabindex="-1" aria-labelledby="detailModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="detailModalLabel">Informasi</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p>Mohon atur waktu dengan benar. Berikut adalah tata cara memasukkan waktu yang benar:</p>
                <ul>
                    <li><strong>Pagi:</strong> Masukkan waktu antara pukul <strong>05:00</strong> dan <strong>10:00</strong>.</li>
                    <li><strong>Siang:</strong> Masukkan waktu antara pukul <strong>11:00</strong> dan <strong>14:00</strong>.</li>
                    <li><strong>Sore:</strong> Masukkan waktu antara pukul <strong>15:00</strong> dan <strong>18:00</strong>.</li>
                </ul>
                <p>Pastikan untuk mematuhi rentang waktu yang telah ditentukan agar sistem dapat berfungsi dengan baik.</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
            </div>
        </div>
    </div>
</div>
<script>
    $(document).ready(function() {
        $('#detailModal').modal('show');
    });
</script>
<?php /**PATH C:\xampp\htdocs\LaraIoT_V3\resources\views/penjadwalanpakan.blade.php ENDPATH**/ ?>