<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard</title>
      <!-- Jquery -->
    <script type="text/javascript" src="<?php echo e(asset('jquery/jquery.min.js')); ?>"></script>
    <script type="text/javascript">
        $(document).ready(function() {
            setInterval(function() {
                $("#suhu").load("<?php echo e(url('bacasuhu')); ?>");
                $("#kelembaban").load("<?php echo e(url('bacakelembaban')); ?>");
                $("#jumlah_pakan").load("<?php echo e(url('bacajarak')); ?>", function(response, status, xhr) {
                    if (status == "success") {
                        updateProgressBar(response);
                    }
                });
            }, 1000);
        });

        // untuk jam 
        function updateClock() {
            var now = new Date();
            var hours = now.getHours();
            var minutes = now.getMinutes();
            var seconds = now.getSeconds();
            minutes = minutes < 10 ? '0' + minutes : minutes;
            seconds = seconds < 10 ? '0' + seconds : seconds;
            var timeString = hours + ':' + minutes + ':' + seconds;
            document.getElementById('clock').innerHTML = timeString;
        }

        setInterval(updateClock, 1000);
        updateClock(); // initial call to display clock immediately

        // untuk bar
        function updateProgressBar(value) {
            var maxHeight = 14; // ketinggian maksimal pakan
            var minHeight = 3; // ketinggian minimal pakan yang dianggap penuh
            var percentage = ((maxHeight - value) / (maxHeight - minHeight)) * 100;
            percentage = Math.max(0, Math.min(100, percentage)); // memastikan persentase antara 0 dan 100

            var feedLevel = document.getElementById("feed-level");
            feedLevel.style.height = percentage + "%";
            feedLevel.setAttribute("aria-valuenow", value);

            // Optional: change color based on level
            if (percentage > 75) {
                feedLevel.style.backgroundColor = "#28a745"; // Hijau
            } else if (percentage > 50) {
                feedLevel.style.backgroundColor = "#ffc107"; // Kuning
            } else if (percentage > 25) {
                feedLevel.style.backgroundColor = "#fd7e14"; // Oren
            } else {
                feedLevel.style.backgroundColor = "#dc3545"; // Merah
            }
        }
    </script>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome CSS -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #f8f9fa, #e9ecef);
            font-family: 'Arial', sans-serif;
        }

        .container {
            margin-top: 40px;
        }

        .card {
            margin-top: 20px;
            border: none;
            box-shadow: 0 6px 18px rgba(0, 0, 0, 0.1);
            transition: transform 0.3s ease;
            border-radius: 12px;
        }

        .card:hover {
            transform: translateY(-10px);
        }

        .card-title {
            font-size: 1.75rem;
            color: #343a40;
        }

        .card-text {
            font-size: 1.25rem;
            color: #6c757d;
        }

        .icon {
            margin-right: 10px;
            color: #17a2b8;
        }

        .input-group-text {
            width: 65px;
            background-color: #17a2b8;
            color: white;
        }

        .input-group input {
            border-left: none;
        }

        .btn-primary {
            background-color: #17a2b8;
            border: none;
            transition: background-color 0.3s ease;
        }

        .btn-primary:hover {
            background-color: #138496;
        }

        .clock {
            text-align: center;
            font-size: 2.5rem;
            margin-top: 20px;
            color: #343a40;
            font-weight: bold;
        }

        .clock div {
            display: inline-block;
            padding: 10px 20px;
            background: #17a2b8;
            color: white;
            border-radius: 8px;
            box-shadow: 0 6px 18px rgba(0, 0, 0, 0.1);
        }

        .clock div:before {
            content: '⌚ ';
        }

        .btn-info.btn-sm {
            border-radius: 50%;
            width: 30px;
            height: 30px;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 0;
        }

        .btn-info.btn-sm i {
            font-size: 1rem;
            color: white;
        }

        .progress {
            background-color: #e9ecef;
            border-radius: 10px;
            overflow: hidden;
            margin-top: 10px;
        }

        .progress-bar {
            background-color: #17a2b8;
            height: 30px;
            transition: width 0.4s ease;
        }

        .feed-container {
            width: 100%;
            height: 170px;
            border: 2px solid #6c757d;
            border-radius: 10px;
            background-color: #e9ecef;
            position: relative;
            overflow: hidden;
            box-shadow: inset 0 0 10px rgba(0, 0, 0, 0.1);
        }

        .feed-level {
            width: 100%;
            height: 0;
            background-color: #17a2b8;
            position: absolute;
            bottom: 0;
            transition: height 0.4s ease;
        }

        .feed-level::before {
            content: '';
            position: absolute;
            top: -20px;
            left: 50%;
            transform: translateX(-50%);
            width: 60%;
            height: 20px;
            /* background-color: #17a2b8; */
            border-radius: 10px 10px 0 0;
        }

        .logout-btn {
            position: absolute;
            top: 20px;
            right: 20px;
        }

        .logout-btn button {
            background-color: #dc3545;
            color: white;
            border: none;
            padding: 10px 20px;
            border-radius: 5px;
            transition: background-color 0.3s ease;
        }

        .logout-btn button:hover {
            background-color: #c82333;
        }

        .welcome-container {
            text-align: start;
            margin-bottom: 20px;
        }

        .profile-link {
            font-size: 1.5rem;
            color: #343a40;
            font-weight: bold;
            margin: 0;
            cursor: pointer;
        }

        .profile-link:hover {
            text-decoration: underline;
        }
    </style>
</head>

<body>
    <div class="logout-btn">
        <form action="<?php echo e(route('logout')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <button type="submit">Logout</button>
        </form>
    </div>
    <div class="container">
        
        
        <div class="welcome-container">
            <?php echo $__env->make('profil', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
           
        </div>

        <div class="clock">
            <div id="clock">
                <?php
                date_default_timezone_set('Asia/Singapore'); // Set timezone sesuai kebutuhan
                echo date('H:i:s');
                ?>
            </div>
        </div>
        
        <div class="row">
            <!-- Kolom untuk data sensor -->
            <div class="col-md-4">
                <div class="card">
                    <div class="card-body">
                        <h2 class="card-title">Suhu dan Kelembaban</h2>
                        <p class="card-text"><i class="fas fa-thermometer-half icon"></i>Suhu: <span id="suhu">-</span> °C</p>
                        <p class="card-text"><i class="fas fa-tint icon"></i>Kelembaban: <span id="kelembaban">-</span>%</p>
                    </div>
                </div>
            </div>

            <!-- Kolom untuk penjadwalan pakan -->
           <?php echo $__env->make('penjadwalanpakan', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <!-- Kolom untuk jumlah pakan -->
            <?php echo $__env->make('ketinggianpakan', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>

   

    

    <!-- Bootstrap JavaScript -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
    <!-- Font Awesome JavaScript -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/js/all.min.js"></script>

    <script>
        // JavaScript for handling the profile modal
        document.addEventListener('DOMContentLoaded', function() {
            var profileModal = new bootstrap.Modal(document.getElementById('profileModal'));
            var profileLink = document.getElementById('profileLink');

            profileLink.onclick = function() {
                profileModal.show();
            }
        });

        // JavaScript for handling the detail modal
        $(document).ready(function() {
            $('#detailModal').modal('show');
        });
    </script>
</body>

</html>
<?php /**PATH C:\xampp\htdocs\LaraIoT_V1\resources\views/dashboard.blade.php ENDPATH**/ ?>